;CodeVisionAVR C Compiler V1.24.5 Standard
;(C) Copyright 1998-2005 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;e-mail:office@hpinfotech.com

;Chip type              : ATmega8
;Program type           : Application
;Clock frequency        : 8.000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 256 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: No
;Enhanced core instructions    : On
;Automatic register allocation : On

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_adc_noise_red=0x10
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@2,@0+@1
	.ENDM

	.MACRO __GETWRMN
	LDS  R@2,@0+@1
	LDS  R@3,@0+@1+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM


	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	RCALL __GETW1PF
	ICALL
	.ENDM


	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMRDW
	ICALL
	.ENDM


	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOV  R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOV  R30,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "Main.vec"
	.INCLUDE "Main.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x400)
	LDI  R25,HIGH(0x400)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x45F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x45F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x160)
	LDI  R29,HIGH(0x160)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.24.5 Standard
;       4 Automatic Program Generator
;       5  Copyright 1998-2005 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 e-mail:office@hpinfotech.com
;       8 
;       9 Project : PC KEBOARD & ATMEGA 8
;      10 Version : 1.0
;      11 Date    : 2006/03/17
;      12 Author  : Behzad khazama                  
;      13 Company : elbaco                          
;      14 Comments: Visit My Site at www.khazama.com
;      15 
;      16 Chip type           : ATmega8
;      17 Program type        : Application
;      18 Clock frequency     : 8.000000 MHz
;      19 Memory model        : Small
;      20 External SRAM size  : 0
;      21 Data Stack size     : 256
;      22 *****************************************************/
;      23 
;      24 #include <mega8.h>
;      25 #include <delay.h>
;      26 #include "kb.h"
;      27 
;      28 void init(void);
;      29 
;      30 // Alphanumeric LCD Module functions
;      31 #asm
;      32    .equ __lcd_port=0x18 ;PORTB
   .equ __lcd_port=0x18 ;PORTB
;      33 #endasm
;      34 #include <lcd.h>
;      35 
;      36 // Declare your global variables here
;      37 
;      38 void main(void)
;      39 {

	.CSEG
_main:
;      40 // Declare your local variables here
;      41 
;      42 init();
	RCALL _init
;      43 init_kb();
	RCALL _init_kb
;      44 
;      45 while (1)
_0x3:
;      46       {
;      47       // Place your code here
;      48         lcd_putchar( getkey() );
	RCALL _getkey
	ST   -Y,R30
	RCALL _lcd_putchar
;      49         delay_ms(50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
;      50       };
	RJMP _0x3
;      51 }
_0x6:
	RJMP _0x6
;      52 
;      53 //===========================================
;      54 //
;      55 void init(void){
_init:
;      56 // Input/Output Ports initialization
;      57 // Port B initialization
;      58 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;      59 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;      60 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
;      61 DDRB=0x00;
	OUT  0x17,R30
;      62 
;      63 // Port C initialization
;      64 // Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;      65 // State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;      66 PORTC=0x00;
	OUT  0x15,R30
;      67 DDRC=0x00;
	OUT  0x14,R30
;      68 
;      69 // Port D initialization
;      70 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;      71 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;      72 PORTD=0x00;
	OUT  0x12,R30
;      73 DDRD=0x00;
	OUT  0x11,R30
;      74 
;      75 // Timer/Counter 0 initialization
;      76 // Clock source: System Clock
;      77 // Clock value: Timer 0 Stopped
;      78 TCCR0=0x00;
	OUT  0x33,R30
;      79 TCNT0=0x00;
	OUT  0x32,R30
;      80 
;      81 // Timer/Counter 1 initialization
;      82 // Clock source: System Clock
;      83 // Clock value: Timer 1 Stopped
;      84 // Mode: Normal top=FFFFh
;      85 // OC1A output: Discon.
;      86 // OC1B output: Discon.
;      87 // Noise Canceler: Off
;      88 // Input Capture on Falling Edge
;      89 TCCR1A=0x00;
	OUT  0x2F,R30
;      90 TCCR1B=0x00;
	OUT  0x2E,R30
;      91 TCNT1H=0x00;
	OUT  0x2D,R30
;      92 TCNT1L=0x00;
	OUT  0x2C,R30
;      93 ICR1H=0x00;
	OUT  0x27,R30
;      94 ICR1L=0x00;
	OUT  0x26,R30
;      95 OCR1AH=0x00;
	OUT  0x2B,R30
;      96 OCR1AL=0x00;
	OUT  0x2A,R30
;      97 OCR1BH=0x00;
	OUT  0x29,R30
;      98 OCR1BL=0x00;
	OUT  0x28,R30
;      99 
;     100 // Timer/Counter 2 initialization
;     101 // Clock source: System Clock
;     102 // Clock value: Timer 2 Stopped
;     103 // Mode: Normal top=FFh
;     104 // OC2 output: Disconnected
;     105 ASSR=0x00;
	OUT  0x22,R30
;     106 TCCR2=0x00;
	OUT  0x25,R30
;     107 TCNT2=0x00;
	OUT  0x24,R30
;     108 OCR2=0x00;
	OUT  0x23,R30
;     109 
;     110 // External Interrupt(s) initialization
;     111 // INT0: On
;     112 // INT0 Mode: Low level
;     113 // INT1: Off
;     114 GICR|=0x40;
	IN   R30,0x3B
	ORI  R30,0x40
	OUT  0x3B,R30
;     115 MCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
;     116 GIFR=0x40;
	LDI  R30,LOW(64)
	OUT  0x3A,R30
;     117 
;     118 // Timer(s)/Counter(s) Interrupt(s) initialization
;     119 TIMSK=0x00;
	LDI  R30,LOW(0)
	OUT  0x39,R30
;     120 
;     121 // Analog Comparator initialization
;     122 // Analog Comparator: Off
;     123 // Analog Comparator Input Capture by Timer/Counter 1: Off
;     124 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
;     125 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
;     126 
;     127 // LCD module initialization
;     128 lcd_init(16);
	LDI  R30,LOW(16)
	ST   -Y,R30
	RCALL _lcd_init
;     129 
;     130 // Global enable interrupts
;     131 #asm("sei")
	sei
;     132 
;     133 }
	RET
;     134 #include <mega8.h>
;     135 #include <string.h>
;     136 #include "kb.h"
;     137 #include "scancodes.h"
;     138 
;     139 #define BUFF_SIZE 64
;     140 
;     141 unsigned char edge, bitcount;                // 0 = neg.  1 = pos.
;     142 
;     143 unsigned char kb_buffer[BUFF_SIZE];

	.DSEG
_kb_buffer:
	.BYTE 0x40
;     144 unsigned char *inpt, *outpt;
;     145 unsigned char buffcnt;
;     146 
;     147 
;     148 void init_kb(void)
;     149 {

	.CSEG
_init_kb:
;     150     inpt =  kb_buffer;                        // Initialize buffer
	RCALL SUBOPT_0x0
;     151     outpt = kb_buffer;
	RCALL SUBOPT_0x1
;     152     buffcnt = 0;
	CLR  R10
;     153 
;     154     MCUCR = 2;                                // INT0 interrupt on falling edge
	RCALL SUBOPT_0x2
;     155     edge = 0;                                // 0 = falling edge  1 = rising edge
;     156     bitcount = 11;
	RCALL SUBOPT_0x3
;     157 }
	RET
;     158 
;     159 interrupt [EXT_INT0] void ext_int0_isr(void)
;     160 {
_ext_int0_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
;     161     static unsigned char data;                // Holds the received scan code

	.DSEG

	.CSEG
;     162 
;     163     if (!edge)                                // Routine entered at falling edge
	TST  R4
	BRNE _0x7
;     164     {
;     165         if(bitcount < 11 && bitcount > 2)    // Bit 3 to 10 is data. Parity bit,
	LDI  R30,LOW(11)
	CP   R5,R30
	BRSH _0x9
	LDI  R30,LOW(2)
	CP   R30,R5
	BRLO _0xA
_0x9:
	RJMP _0x8
_0xA:
;     166         {                                    // start and stop bits are ignored.
;     167             data = (data >> 1);
	LSR  R11
;     168             if(PIND & 8)
	SBIS 0x10,3
	RJMP _0xB
;     169                 data = data | 0x80;            // Store a '1'
	LDI  R30,LOW(128)
	OR   R11,R30
;     170         }
_0xB:
;     171 
;     172         MCUCR = 3;                            // Set interrupt on rising edge
_0x8:
	LDI  R30,LOW(3)
	OUT  0x35,R30
;     173         edge = 1;
	LDI  R30,LOW(1)
	MOV  R4,R30
;     174         
;     175     } else {                                // Routine entered at rising edge
	RJMP _0xC
_0x7:
;     176 
;     177         MCUCR = 2;                            // Set interrupt on falling edge
	RCALL SUBOPT_0x2
;     178         edge = 0;
;     179 
;     180         if(--bitcount == 0)                    // All bits received
	DEC  R5
	BRNE _0xD
;     181         {
;     182             decode(data);
	ST   -Y,R11
	RCALL _decode
;     183             bitcount = 11;
	RCALL SUBOPT_0x3
;     184         }
;     185     }
_0xD:
_0xC:
;     186 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;     187 
;     188 
;     189 void decode(unsigned char sc)
;     190 {
_decode:
;     191     static unsigned char is_up=0, shift = 0, mode = 0 , is_extend=0;

	.DSEG
_is_extend_S4:
	.BYTE 0x1

	.CSEG
;     192     unsigned char i;
;     193 
;     194     if (!is_up)                // Last data received was the up-key identifier
	ST   -Y,R16
;	sc -> Y+1
;	i -> R16
	TST  R12
	BREQ PC+2
	RJMP _0xE
;     195     {
;     196         switch (sc)
	LDD  R30,Y+1
;     197         {            
;     198            
;     199           case 0xF0 :        // The up-key identifier
	CPI  R30,LOW(0xF0)
	BRNE _0x12
;     200             is_up = 1;
	LDI  R30,LOW(1)
	MOV  R12,R30
;     201             break;
	RJMP _0x11
;     202 
;     203           case 0x12 :        // Left SHIFT
_0x12:
	CPI  R30,LOW(0x12)
	BRNE _0x13
;     204             shift = 1;
	RCALL SUBOPT_0x4
;     205             break;
	RJMP _0x11
;     206 
;     207           case 0x59 :        // Right SHIFT
_0x13:
	CPI  R30,LOW(0x59)
	BRNE _0x15
;     208             shift = 1;
	RCALL SUBOPT_0x4
;     209             break;
	RJMP _0x11
;     210 
;     211           default: 
_0x15:
;     212                if(is_extend!=0xE0){ 
	LDS  R26,_is_extend_S4
	CPI  R26,LOW(0xE0)
	BREQ _0x16
;     213                 if(!shift)                    // If shift not pressed,
	TST  R13
	BRNE _0x17
;     214                 {                            // do a table look-up
;     215                     for(i = 0; unshifted[i][0]!=sc && unshifted[i][0]; i++);
	LDI  R16,LOW(0)
_0x19:
	RCALL SUBOPT_0x5
	RCALL SUBOPT_0x6
	BREQ _0x1B
	RCALL SUBOPT_0x5
	CPI  R30,0
	BRNE _0x1C
_0x1B:
	RJMP _0x1A
_0x1C:
	SUBI R16,-1
	RJMP _0x19
_0x1A:
;     216                     if (unshifted[i][0] == sc) {
	RCALL SUBOPT_0x5
	RCALL SUBOPT_0x6
	BRNE _0x1D
;     217                         put_kbbuff(unshifted[i][1]);
	LDI  R26,LOW(_unshifted*2)
	LDI  R27,HIGH(_unshifted*2)
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x8
;     218                     }
;     219                 } else {                    // If shift pressed
_0x1D:
	RJMP _0x1E
_0x17:
;     220                     for(i = 0; shifted[i][0]!=sc && shifted[i][0]; i++);
	LDI  R16,LOW(0)
_0x20:
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0xA
	BREQ _0x22
	RCALL SUBOPT_0x9
	LPM  R30,Z
	CPI  R30,0
	BRNE _0x23
_0x22:
	RJMP _0x21
_0x23:
	SUBI R16,-1
	RJMP _0x20
_0x21:
;     221                     if (shifted[i][0] == sc) {
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0xA
	BRNE _0x24
;     222                         put_kbbuff(shifted[i][1]);
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0x8
;     223                     }
;     224                 }  
_0x24:
_0x1E:
;     225                } else{
	RJMP _0x25
_0x16:
;     226                 for(i = 0; extended[i][0]!=sc && extended[i][0]; i++);
	LDI  R16,LOW(0)
_0x27:
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xC
	BREQ _0x29
	RCALL SUBOPT_0xB
	SBIW R30,0
	BRNE _0x2A
_0x29:
	RJMP _0x28
_0x2A:
	SUBI R16,-1
	RJMP _0x27
_0x28:
;     227                 if(extended[i][0]==sc) {
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xC
	BRNE _0x2B
;     228                     put_string(extended[i][1]);               
	LDI  R26,LOW(_extended*2)
	LDI  R27,HIGH(_extended*2)
	MOV  R30,R16
	LDI  R31,0
	RCALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	RCALL __GETW1PF
	ST   -Y,R31
	ST   -Y,R30
	RCALL _put_string
;     229                 }    
;     230                } 
_0x2B:
_0x25:
;     231             break;
;     232         }
_0x11:
;     233     } else {
	RJMP _0x2C
_0xE:
;     234         is_up = 0;                            // Two 0xF0 in a row not allowed
	CLR  R12
;     235         switch (sc)
	LDD  R30,Y+1
;     236         {
;     237           case 0x12 :                        // Left SHIFT
	CPI  R30,LOW(0x12)
	BRNE _0x30
;     238             shift = 0;
	CLR  R13
;     239             break;
	RJMP _0x2F
;     240             
;     241           case 0x59 :                        // Right SHIFT
_0x30:
	CPI  R30,LOW(0x59)
	BRNE _0x2F
;     242             shift = 0;
	CLR  R13
;     243             break;
;     244 
;     245         } 
_0x2F:
;     246     }   
_0x2C:
;     247 
;     248 is_extend=sc;
	LDD  R30,Y+1
	STS  _is_extend_S4,R30
;     249 
;     250 } 
	LDD  R16,Y+0
	ADIW R28,2
	RET
;     251 
;     252 void put_kbbuff(unsigned char c)
;     253 {
_put_kbbuff:
;     254     if (buffcnt<BUFF_SIZE)                        // If buffer not full
	LDI  R30,LOW(64)
	CP   R10,R30
	BRSH _0x32
;     255     {
;     256         *inpt = c;                                // Put character into buffer
	LD   R30,Y
	__GETW2R 6,7
	ST   X,R30
;     257         inpt++;                                    // Increment pointer
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 6,7,30,31
;     258 
;     259         buffcnt++;
	INC  R10
;     260 
;     261         if (inpt >= kb_buffer + BUFF_SIZE)        // Pointer wrapping
	__POINTW1MN _kb_buffer,64
	CP   R6,R30
	CPC  R7,R31
	BRLO _0x33
;     262             inpt = kb_buffer;
	RCALL SUBOPT_0x0
;     263     }
_0x33:
;     264 }
_0x32:
	ADIW R28,1
	RET
;     265 
;     266 int getkey(void)
;     267 {
_getkey:
;     268     int byte;
;     269     while(buffcnt == 0);                        // Wait for data
	RCALL __SAVELOCR2
;	byte -> R16,R17
_0x34:
	TST  R10
	BREQ _0x34
;     270 
;     271     byte = *outpt;                                // Get byte
	__GETW2R 8,9
	LD   R30,X
	LDI  R31,0
	__PUTW1R 16,17
;     272     outpt++;                                    // Increment pointer
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 8,9,30,31
;     273 
;     274     if (outpt >= kb_buffer + BUFF_SIZE)            // Pointer wrapping
	__POINTW1MN _kb_buffer,64
	CP   R8,R30
	CPC  R9,R31
	BRLO _0x37
;     275         outpt = kb_buffer;
	RCALL SUBOPT_0x1
;     276     
;     277     buffcnt--;                                    // Decrement buffer count
_0x37:
	DEC  R10
;     278 
;     279     return byte;
	__GETW1R 16,17
	RCALL __LOADLOCR2P
	RET
;     280 }
;     281 
;     282 /*
;     283 void put_hexbyte(unsigned char i)
;     284 {
;     285     unsigned char h, l;
;     286     
;     287     h = i & 0xF0;               // High nibble
;     288     h = h>>4;
;     289     h = h + '0';
;     290     
;     291     if (h > '9')
;     292         h = h + 7;
;     293 
;     294     l = (i & 0x0F)+'0';         // Low nibble
;     295     if (l > '9')
;     296         l = l + 7;
;     297 
;     298     put_kbbuff(h);
;     299     put_kbbuff(l);
;     300 }
;     301 */  
;     302 void put_string(flash unsigned char * i){
_put_string:
;     303 unsigned char j=0;
;     304 for(j=0;j<strlenf(i);j++){
	ST   -Y,R16
;	*i -> Y+1
;	j -> R16
	LDI  R16,0
	LDI  R16,LOW(0)
_0x39:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _strlenf
	MOV  R26,R16
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	BRSH _0x3A
;     305    put_kbbuff( *(i+j) )   ;  
	MOV  R30,R16
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	RCALL _put_kbbuff
;     306  }
	SUBI R16,-1
	RJMP _0x39
_0x3A:
;     307 }
	LDD  R16,Y+0
	ADIW R28,3
	RET

    .equ __lcd_direction=__lcd_port-1
    .equ __lcd_pin=__lcd_port-2
    .equ __lcd_rs=0
    .equ __lcd_rd=1
    .equ __lcd_enable=2
    .equ __lcd_busy_flag=7

	.DSEG
__base_y_G3:
	.BYTE 0x4
__lcd_x:
	.BYTE 0x1
__lcd_y:
	.BYTE 0x1
__lcd_maxx:
	.BYTE 0x1

	.CSEG
__lcd_delay_G3:
    ldi   r31,15
__lcd_delay0:
    dec   r31
    brne  __lcd_delay0
	RET
__lcd_ready:
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
    cbi   __lcd_port,__lcd_rs     ;RS=0
__lcd_busy:
	RCALL __lcd_delay_G3
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G3
    in    r26,__lcd_pin
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G3
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G3
    cbi   __lcd_port,__lcd_enable ;EN=0
    sbrc  r26,__lcd_busy_flag
    rjmp  __lcd_busy
	RET
__lcd_write_nibble_G3:
    andi  r26,0xf0
    or    r26,r27
    out   __lcd_port,r26          ;write
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G3
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G3
	RET
__lcd_write_data:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf0 | (1<<__lcd_rs) | (1<<__lcd_rd) | (1<<__lcd_enable) ;set as output    
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	RCALL __lcd_write_nibble_G3
    ld    r26,y
    swap  r26
	RCALL __lcd_write_nibble_G3
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
__lcd_read_nibble_G3:
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G3
    in    r30,__lcd_pin           ;read
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G3
    andi  r30,0xf0
	RET
_lcd_read_byte0_G3:
	RCALL __lcd_delay_G3
	RCALL __lcd_read_nibble_G3
    mov   r26,r30
	RCALL __lcd_read_nibble_G3
    cbi   __lcd_port,__lcd_rd     ;RD=0
    swap  r30
    or    r30,r26
	RET
_lcd_gotoxy:
	RCALL __lcd_ready
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G3)
	SBCI R31,HIGH(-__base_y_G3)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R30,R26
	RCALL SUBOPT_0xD
	LDD  R30,Y+1
	STS  __lcd_x,R30
	LD   R30,Y
	STS  __lcd_y,R30
	ADIW R28,2
	RET
_lcd_clear:
	RCALL __lcd_ready
	LDI  R30,LOW(2)
	RCALL SUBOPT_0xD
	RCALL __lcd_ready
	LDI  R30,LOW(12)
	RCALL SUBOPT_0xD
	RCALL __lcd_ready
	LDI  R30,LOW(1)
	RCALL SUBOPT_0xD
	LDI  R30,LOW(0)
	STS  __lcd_y,R30
	STS  __lcd_x,R30
	RET
_lcd_putchar:
    push r30
    push r31
    ld   r26,y
    set
    cpi  r26,10
    breq __lcd_putchar1
    clt
	LDS  R30,__lcd_x
	SUBI R30,-LOW(1)
	STS  __lcd_x,R30
	LDS  R30,__lcd_maxx
	LDS  R26,__lcd_x
	CP   R30,R26
	BRSH _0x3C
	__lcd_putchar1:
	LDS  R30,__lcd_y
	SUBI R30,-LOW(1)
	STS  __lcd_y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDS  R30,__lcd_y
	ST   -Y,R30
	RCALL _lcd_gotoxy
	brts __lcd_putchar0
_0x3C:
    rcall __lcd_ready
    sbi  __lcd_port,__lcd_rs ;RS=1
    ld   r26,y
    st   -y,r26
    rcall __lcd_write_data
__lcd_putchar0:
    pop  r31
    pop  r30
	ADIW R28,1
	RET
__long_delay_G3:
    clr   r26
    clr   r27
__long_delay0:
    sbiw  r26,1         ;2 cycles
    brne  __long_delay0 ;2 cycles
	RET
__lcd_init_write_G3:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	RCALL __lcd_write_nibble_G3
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
_lcd_init:
    cbi   __lcd_port,__lcd_enable ;EN=0
    cbi   __lcd_port,__lcd_rs     ;RS=0
	LD   R30,Y
	STS  __lcd_maxx,R30
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G3,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G3,3
	RCALL SUBOPT_0xE
	RCALL SUBOPT_0xE
	RCALL SUBOPT_0xE
	RCALL __long_delay_G3
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL __lcd_init_write_G3
	RCALL __long_delay_G3
	LDI  R30,LOW(40)
	RCALL SUBOPT_0xD
	RCALL __long_delay_G3
	LDI  R30,LOW(4)
	RCALL SUBOPT_0xD
	RCALL __long_delay_G3
	LDI  R30,LOW(133)
	RCALL SUBOPT_0xD
	RCALL __long_delay_G3
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RCALL _lcd_read_byte0_G3
	CPI  R30,LOW(0x5)
	BREQ _0x3D
	LDI  R30,LOW(0)
	RJMP _0x3E
_0x3D:
	RCALL __lcd_ready
	LDI  R30,LOW(6)
	RCALL SUBOPT_0xD
	RCALL _lcd_clear
	LDI  R30,LOW(1)
_0x3E:
	ADIW R28,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x0:
	LDI  R30,LOW(_kb_buffer)
	LDI  R31,HIGH(_kb_buffer)
	__PUTW1R 6,7
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1:
	LDI  R30,LOW(_kb_buffer)
	LDI  R31,HIGH(_kb_buffer)
	__PUTW1R 8,9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2:
	LDI  R30,LOW(2)
	OUT  0x35,R30
	CLR  R4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x3:
	LDI  R30,LOW(11)
	MOV  R5,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x4:
	LDI  R30,LOW(1)
	MOV  R13,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x5:
	LDI  R26,LOW(_unshifted*2)
	LDI  R27,HIGH(_unshifted*2)
	MOV  R30,R16
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x6:
	MOV  R26,R30
	LDD  R30,Y+1
	CP   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES
SUBOPT_0x7:
	MOV  R30,R16
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x8:
	ADIW R30,1
	LPM  R30,Z
	ST   -Y,R30
	RJMP _put_kbbuff

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x9:
	LDI  R26,LOW(_shifted*2)
	LDI  R27,HIGH(_shifted*2)
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xA:
	LPM  R30,Z
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0xB:
	LDI  R26,LOW(_extended*2)
	LDI  R27,HIGH(_extended*2)
	MOV  R30,R16
	LDI  R31,0
	RCALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	RCALL __GETW1PF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xC:
	MOVW R26,R30
	LDD  R30,Y+1
	LDI  R31,0
	CP   R30,R26
	CPC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES
SUBOPT_0xD:
	ST   -Y,R30
	RJMP __lcd_write_data

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0xE:
	RCALL __long_delay_G3
	LDI  R30,LOW(48)
	ST   -Y,R30
	RJMP __lcd_init_write_G3

_strlenf:
	clr  r26
	clr  r27
	ld   r30,y+
	ld   r31,y+
__strlenf0:
	lpm  r0,z+
	tst  r0
	breq __strlenf1
	adiw r26,1
	rjmp __strlenf0
__strlenf1:
	movw r30,r26
	ret

_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR2P:
	LD   R16,Y+
	LD   R17,Y+
	RET

;END OF CODE MARKER
__END_OF_CODE:
